/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.event.ContextualizedEvent;
import dev.yumi.commons.event.Event;
import dev.yumi.commons.function.YumiPredicates;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilteredEvent<I extends Comparable<? super I>, T, C>
extends Event<I, T> {
    private final Map<C, WeakReference<ContextualizedEvent<I, T, C>>> contextualizedEvents = new WeakHashMap<C, WeakReference<ContextualizedEvent<I, T, C>>>();

    FilteredEvent(@NotNull Class<? super T> type, @NotNull I defaultPhaseId, @NotNull Function<T[], T> invokerFactory) {
        super(type, defaultPhaseId, invokerFactory);
    }

    @Override
    public void register(@NotNull T listener, @NotNull Predicate<C> filter) {
        this.register(this.defaultPhaseId(), listener, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull I phaseIdentifier, @NotNull T listener, @NotNull Predicate<C> filter) {
        Objects.requireNonNull(phaseIdentifier, "Cannot register a listener for a null phase.");
        Objects.requireNonNull(listener, "Cannot register a null listener.");
        Objects.requireNonNull(filter, "Cannot register a listener with a null context filter.");
        this.lock.lock();
        try {
            ((FilteredPhaseData)this.getOrCreatePhase((Comparable)phaseIdentifier, true)).addListener(new Listener<T, C>(listener, filter));
            this.rebuildInvoker(this.listeners.length);
            this.notifyContextualizedOfRegistration(phaseIdentifier, listener, filter);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContextualizedEvent<I, T, C> forContext(@NotNull C context) {
        return this.forContext(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextualizedEvent<I, T, C> forContext(@NotNull C context, boolean replace) {
        this.lock.lock();
        try {
            ContextualizedEvent existingRef;
            if (replace) {
                ContextualizedEvent contextualized = new ContextualizedEvent(this, context);
                this.contextualizedEvents.put(context, new WeakReference(contextualized));
                ContextualizedEvent contextualizedEvent = contextualized;
                return contextualizedEvent;
            }
            WeakReference<ContextualizedEvent<I, T, C>> existing = this.contextualizedEvents.get(context);
            if (existing != null && (existingRef = (ContextualizedEvent)existing.get()) != null) {
                ContextualizedEvent contextualizedEvent = existingRef;
                return contextualizedEvent;
            }
            ContextualizedEvent contextualized = new ContextualizedEvent(this, context);
            this.contextualizedEvents.put(context, new WeakReference(contextualized));
            ContextualizedEvent contextualizedEvent = contextualized;
            return contextualizedEvent;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void doRegister(@NotNull I phaseIdentifier, @NotNull T listener) {
        super.doRegister(phaseIdentifier, listener);
        this.notifyContextualizedOfRegistration(phaseIdentifier, listener, YumiPredicates.alwaysTrue());
    }

    private void notifyContextualizedOfRegistration(@NotNull I phaseIdentifier, @NotNull T listener, @NotNull Predicate<C> selector) {
        for (WeakReference<ContextualizedEvent<I, T, C>> contextualized : this.contextualizedEvents.values()) {
            ContextualizedEvent value = (ContextualizedEvent)contextualized.get();
            if (value == null) continue;
            value.registerFromParent(phaseIdentifier, listener, selector);
        }
    }

    @Override
    void doAddPhaseOrdering(@NotNull I firstPhase, @NotNull I secondPhase) {
        super.doAddPhaseOrdering(firstPhase, secondPhase);
        for (WeakReference<ContextualizedEvent<I, T, C>> contextualized : this.contextualizedEvents.values()) {
            ContextualizedEvent value = (ContextualizedEvent)contextualized.get();
            if (value == null) continue;
            value.addPhaseOrdering(firstPhase, secondPhase);
        }
    }

    FilteredPhaseData getOrCreatePhase(@NotNull I id, boolean sortIfCreate) {
        Event.PhaseData phase = (Event.PhaseData)((Object)this.phases.get(id));
        if (phase == null) {
            phase = new FilteredPhaseData(this, id, this.type());
            this.phases.put(id, phase);
            this.sortedPhases.add(phase);
            if (sortIfCreate) {
                this.sortPhases();
            }
        }
        return (FilteredPhaseData)phase;
    }

    @Override
    void rebuildInvoker(int newLength) {
        super.rebuildInvoker(newLength);
    }

    @ApiStatus.Internal
    static final class FilteredPhaseData
    extends Event.PhaseData<I, T> {
        Listener<T, C>[] listenersData;
        final /* synthetic */ FilteredEvent this$0;

        FilteredPhaseData(@NotNull I id, Class<? super T> listenerType) {
            this.this$0 = this$0;
            super(id, listenerType);
            this.listenersData = new Listener[0];
        }

        @Override
        void addListener(@NotNull T listener) {
            super.addListener(listener);
            this.addListener(new Listener(listener, null));
        }

        @Override
        void addListener(@NotNull Listener<T, C> listener) {
            int oldLength = this.listenersData.length;
            this.listenersData = Arrays.copyOf(this.listenersData, oldLength + 1);
            this.listenersData[oldLength] = listener;
        }

        Event.PhaseData<I, T> copyFor(@NotNull C context) {
            return new Event.PhaseData((Comparable)this.getId(), Arrays.stream(this.listenersData).filter(listener -> listener.shouldListen(context)).map(Listener::listener).toArray(length -> (Object[])Array.newInstance(this.listeners.getClass().componentType(), length)));
        }
    }

    @ApiStatus.Internal
    record Listener<T, C>(T listener, @Nullable Predicate<C> selector) {
        boolean shouldListen(C context) {
            return this.selector == null || this.selector.test(context);
        }
    }
}

